//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property description "Chart Trade Base Indicator."
#property description "See the articles for more details."
#property version   "1.122"
#property icon "/Images/Market Replay/Icons/Indicators.ico"
#property link "https://www.mql5.com/"
#property indicator_chart_window
#property indicator_plots 0
//+------------------------------------------------------------------+
#include <Market Replay\Chart Trader\C_ChartFloatingRAD.mqh>
//+------------------------------------------------------------------+
#define def_ShortName "Indicator Chart Trade"
//+------------------------------------------------------------------+
C_ChartFloatingRAD *chart = NULL;
//+------------------------------------------------------------------+
input ushort user01 = 1;			//Leverage
input double user02 = 100.5;		//Finance Take
input double user03 = 75.4;		//Finance Stop
//+------------------------------------------------------------------+
int OnInit()
{
	chart = new C_ChartFloatingRAD(def_ShortName, user01, user02, user03);
	
	if (_LastError >= ERR_USER_ERROR_FIRST) return INIT_FAILED;

	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
	return rates_total;
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
	if (_LastError < ERR_USER_ERROR_FIRST) 
		(*chart).DispatchMessage(id, lparam, dparam, sparam);
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	switch (reason)
	{
		case REASON_INITFAILED:
			ChartIndicatorDelete(ChartID(), 0, def_ShortName);
			break;
		case REASON_CHARTCHANGE:
			(*chart).SaveState();
			break;
	}

	delete chart;
}
//+------------------------------------------------------------------+